## Excel Conversion Functions

A set of Excel like functions supported by icCube



### Return

```
void
```



### Description

A list of Excel Text functions to follow MDX standard. We would advise using Java function if available instead.
<UL>
<LI><b>CDate</b>(string s), converts a string into a date using formats as ('M/d/y h:m:s','M/d/y', 'M-d-y h:m:s'... )
<LI><b>CDbl</b>(string s), converts the string parameter to a numerical value (double).
<LI><b>CLng</b>(string s), converts the string parameter to an integer value (integer)
<LI><b>CLngLng</b>(string s), converts the string parameter to an integer value (long).
<LI><b>CSng</b>(string s), converts the string parameter to a numerical value (float).
<LI><b>CStr</b>(object s), returns the string representation of the parameter (True/False for boolean values).
<LI><b>Str</b>(object s), returns the string representation of the parameter  (true/false for boolean values).
<LI><b>Val</b>(object s), converts the string parameter into a numerical value.
</UL>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CDate(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the date of the string parameter (M/d/y, M-d-y).

**Query**

```
CDate('8/2/2012')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2012-08-02T00:00:00.000</td></tr></table>


**Assertion : MDX Equals**

```
DateTime(2012,8,2,0,0)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CDbl(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the numeric representation of the string parameter.

**Query**

```
CDbl('2.21')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2.21</td></tr></table>


**Assertion : MDX Equals**

```
2.21
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CSng(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the numeric representation of the string parameter.

As CSng is returning a float (32bits), its double representation (64bits) - used in icCube's engine - does not match exactly 2.21.

**Query**

```
CSng('2.21')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2.2100000381469727</td></tr></table>


**Assertion : MDX Equals**

```
2.2100000381469727
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CLng(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the integer representation of the string parameter.

**Query**

```
CLng('221')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>221</td></tr></table>


**Assertion : MDX Equals**

```
221
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CLngLng(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the integer representation of the string parameter.

**Query**

```
CLngLng('221')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>221</td></tr></table>


**Assertion : MDX Equals**

```
221
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CStr(integer)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string representation

**Query**

```
CStr(221)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>221</td></tr></table>


**Assertion : MDX Equals**

```
"221"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CStr(boolean)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string representation

**Query**

```
CStr(false)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>False</td></tr></table>


**Assertion : MDX Equals**

```
"False"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Str(boolean)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string representation

**Query**

```
Str(false)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
"false"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Str(numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the string representation

**Query**

```
Str(145)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>145</td></tr></table>


**Assertion : MDX Equals**

```
"145"
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Val( object )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the numerical representation of its parameter.

**Query**

```
with
  member v00 as Val( '10 Main Street' )
  member v01 as Val( 'Main 10 Street' )
  member v02 as Val( '10MainStreet' )
  member v03 as Val( '34 10 Main Street' )
  member v04 as Val( '  34 10 Main Street' )
  member v05 as Val( '  34 - 10 Main Street' )
  member v06 as Val( '075' )
  member v07 as Val( '1,2 Main Street' )
  member v08 as Val( '1.2 Main Street' )
  member v09 as Val( '1 . 2 Main Street' )
  member v10 as Val( '1.2e3 Main Street' )
  member v11 as Val( '1.2 e 3 Main Street' )
  member v12 as Val( '1.2 e -3 Main Street' )
  member v13 as Val( '- 1.2 e 3 Main Street' )
  member v14 as Val( '' )
  member v15 as Val( null )
  member v16 as Val( 1 )
  member v17 as Val( 1.2 )
  member v18 as Val('1 \t . 2 Main Street' )
  member v19 as Val( 'ABC' )
  member v20 as Val( 'ABC 1000' )
  member v21 as Val( '1000' )
  member v22 as Val( '+-1000' )
  member v23 as Val( True )
  member v24 as Val( False )
  member v25 as Val( '1000' )
  member v26 as Val( '1E3' )
  member v27 as Val( '1000.0' )
  member v28 as Val( '.123' )
  member v29 as Val( '123.' )
  member v30 as Val( '123.e2' )
  member v31 as Val( '123.e' )
  member v32 as Val( '123.e-' )
  member v33 as Val( '123.e 2' )
  member v34 as Val( '1234567890' )

select
  { v00, v01, v02, v03, v04, v05, v06, v07, v08, v09, v10, v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, v21, v22, v23, v24, v25, v26, v27, v28, v29, v30, v31, v32, v33, v34 }  on 0

from [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">v00</td>
  <td class="ic3-mdx-result-cell-header">v01</td>
  <td class="ic3-mdx-result-cell-header">v02</td>
  <td class="ic3-mdx-result-cell-header">v03</td>
  <td class="ic3-mdx-result-cell-header">v04</td>
  <td class="ic3-mdx-result-cell-header">v05</td>
  <td class="ic3-mdx-result-cell-header">v06</td>
  <td class="ic3-mdx-result-cell-header">v07</td>
  <td class="ic3-mdx-result-cell-header">v08</td>
  <td class="ic3-mdx-result-cell-header">v09</td>
  <td class="ic3-mdx-result-cell-header">v10</td>
  <td class="ic3-mdx-result-cell-header">v11</td>
  <td class="ic3-mdx-result-cell-header">v12</td>
  <td class="ic3-mdx-result-cell-header">v13</td>
  <td class="ic3-mdx-result-cell-header">v14</td>
  <td class="ic3-mdx-result-cell-header">v15</td>
  <td class="ic3-mdx-result-cell-header">v16</td>
  <td class="ic3-mdx-result-cell-header">v17</td>
  <td class="ic3-mdx-result-cell-header">v18</td>
  <td class="ic3-mdx-result-cell-header">v19</td>
  <td class="ic3-mdx-result-cell-header">v20</td>
  <td class="ic3-mdx-result-cell-header">v21</td>
  <td class="ic3-mdx-result-cell-header">v22</td>
  <td class="ic3-mdx-result-cell-header">v23</td>
  <td class="ic3-mdx-result-cell-header">v24</td>
  <td class="ic3-mdx-result-cell-header">v25</td>
  <td class="ic3-mdx-result-cell-header">v26</td>
  <td class="ic3-mdx-result-cell-header">v27</td>
  <td class="ic3-mdx-result-cell-header">v28</td>
  <td class="ic3-mdx-result-cell-header">v29</td>
  <td class="ic3-mdx-result-cell-header">v30</td>
  <td class="ic3-mdx-result-cell-header">v31</td>
  <td class="ic3-mdx-result-cell-header">v32</td>
  <td class="ic3-mdx-result-cell-header">v33</td>
  <td class="ic3-mdx-result-cell-header">v34</td>
</tr>
<tr>
 <td>10</td>
 <td>0</td>
 <td>10</td>
 <td>3410</td>
 <td>3410</td>
 <td>34</td>
 <td>75</td>
 <td>1</td>
 <td>1.2</td>
 <td>1.2</td>
 <td>1200</td>
 <td>1200</td>
 <td>0.0012</td>
 <td>-1200</td>
 <td>0</td>
 <td>0</td>
 <td>1</td>
 <td>1.2</td>
 <td>1</td>
 <td>0</td>
 <td>0</td>
 <td>1000</td>
 <td>0</td>
 <td>-1</td>
 <td>0</td>
 <td>1000</td>
 <td>1000</td>
 <td>1000</td>
 <td>0.123</td>
 <td>123</td>
 <td>12300</td>
 <td>123</td>
 <td>123</td>
 <td>12300</td>
 <td>1234567890</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
  member v00 as 10
  member v01 as 0
  member v02 as 10
  member v03 as 3410
  member v04 as 3410
  member v05 as 34
  member v06 as 75
  member v07 as 1
  member v08 as 1.2
  member v09 as 1.2
  member v10 as 1200
  member v11 as 1200
  member v12 as 0.0012
  member v13 as -1200
  member v14 as 0
  member v15 as 0
  member v16 as 1
  member v17 as 1.2
  member v18 as 1
  member v19 as 0
  member v20 as 0
  member v21 as 1000
  member v22 as 0
  member v23 as -1
  member v24 as 0
  member v25 as 1000
  member v26 as 1000
  member v27 as 1000
  member v28 as 0.123
  member v29 as 123
  member v30 as 12300
  member v31 as 123
  member v32 as 123
  member v33 as 12300
  member v34 as 1234567890

select
  { v00, v01, v02, v03, v04, v05, v06, v07, v08, v09, v10, v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, v21, v22, v23, v24, v25, v26, v27, v28, v29, v30, v31, v32, v33, v34 }  on 0

from [Sales]
```


 
</div>

                                                                                                            

### See Also


[Excel Date Functions](Excel%20Date%20Functions.md)

[Excel Numerical Functions](Excel%20Numerical%20Functions.md)

[Excel Text Functions](Excel%20Text%20Functions.md)

[Java Functions](Java%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
